﻿using System;
using Microsoft.SharePoint;
using Microsoft.SharePoint.Administration;

namespace CreateNewSiteCollectionWithSSSC
{
   class Program
   {
      static void Main(string[] args)
      {
         // SSSC aktivieren
         SPWebApplication app = SPWebApplication.Lookup(
            new Uri("http://contoso.de"));
         app.SelfServiceSiteCreationEnabled = true;
         app.Update();

         // Neue Site Collection erzeugen
         using (SPSite site = new SPSite("http://contoso.de"))
         {
            SPSite newSite = site.SelfServiceCreateSite(
                                 "http://contoso.de/sites/test",
                                 "Wiki",
                                 String.Empty,
                                 (uint)1031,
                                 "Wiki#0",
                                 "itacs\\fm",
                                 "Fabian Moritz",
                                 "fm@itacs.de",
                                 "itacs\\fm",
                                 "Fabian Moritz",
                                 "fm@itacs.de");

            Console.WriteLine("Site Collection wurde erfolgreich erstellt: {0}",
            newSite.Url);
         }
      }
   }
}